<!doctype html>
<html>

<head>
    <meta charset="utf-8">
    <style>
        body {
            font-family: 'Arial', sans-serif;
        }

        .border-black {
            border-color: #000000;
        }

        .border-solid {
            border-style: solid;
        }

        .border-2 {
            border-width: 2px;
        }

        .w-full {
            width: 100%;
        }

        .w-48 {
            width: 192px;
        }

        .p-5 {
            padding: 20px;
        }
        .pl-5 {
            padding-left: 20px;
        }

        .pb-5 {
            padding-bottom: 20px;
        }

        .text-xs {
            font-size: 0.75rem;
            line-height: 1rem;
        }

        .text-left {
            text-align: left !important;
        }

        .text-center{
            text-align: center;
        }

        .border-collapse{
            border-collapse: collapse !important;
        }

        .border{
            border: 1px solid #000 !important;
        }
    </style>
</head>

<body>
    <div class="border-black border-solid border-2 w-full">
        <table>

            <!-- Colocacion del logo del reporte, y el titulo dependiendo el tipo de sucursal -->
            <tr>
                <td> <img class="w-48 p-5" src="images/reportes/logo.jpg" /> </td>
                <th>
                    <h4>{{ $titulo }}</h4>
                </th>
            </tr>


            <!-- Fechas en las que se realiza la busqueda de datos -->
            <tr>
                <th class="pl-5 text-xs text-left">
                    <span>Fecha inicio: {{ $fechaInicial }}</span>
                </th>
            </tr>
            <tr>
                <th class="pl-5 pb-5 text-xs text-left">
                    <span>Fecha fin: {{ $fechaFinal }} </span>
                </th>
            </tr>
        </table>
    </div>

    <br>

    <div class="w-full">
        <table class="border-collapse border" style="width: 100%">
            <thead>
                <tr style="font-size: 7px;">
                    <th class="border">#</th>
                    <th class="border">FECHA</th>
                    <th class="border">CODIGO</th>
                    <th class="border">PRODUCTO</th>
                    <th class="border">DENOMINACIÓN DISTINTIVA</th>
                    <th class="border">DENOMINACIÓN GENÉRICA</th>
                    <th class="border">PRESENTACIÓN</th>
                    <th class="border">LABORATORIO</th>
                    <th class="border">PROCEDENCIA</th>
                    <th class="border">NOMBRE DE QUIEN PRESCRIBE</th>
                    <th class="border">DOMICILIO</th>
                    <th class="border">CEDULA PROFESIONAL</th>
                    <th class="border">NÚMERO DE FACTURA</th>
                    <th class="border">NÚMERO DE RECETA</th>
                    <th class="border">CANTIDAD ADQUIRIDA</th>
                    <th class="border">CANTIDAD VENDIDA</th>
                    <th class="border">SALDO</th>
                    <th class="border">OBSERVACIONES</th>
                </tr>
            </thead>

            <tbody>
                @foreach ($consultaRegistros as $dataRegistro)
                    <tr style="font-size: 6px;" class="text-center">
                        <td class="border">{{ $dataRegistro['id'] }}</td>
                        <td class="border">{{ $dataRegistro['fecha'] }}</td>
                        <td class="border">{{ $dataRegistro['codigo_producto'] }}</td>
                        <td class="border">{{ $dataRegistro['producto'] }}</td>
                        <td class="border">{{ $dataRegistro['denominacion_dist'] }}</td>
                        <td class="border">{{ $dataRegistro['denominacion_gen'] }}</td>
                        <td class="border">{{ $dataRegistro['presentacion'] }}</td>
                        <td class="border">{{ $dataRegistro['laboratorio'] }}</td>
                        <td class="border">{{ $dataRegistro['procedencia'] }}</td>
                        <td class="border">{{ $dataRegistro['nombre_pree'] }}</td>
                        <td class="border">{{ $dataRegistro['domicilio'] }}</td>
                        <td class="border">{{ $dataRegistro['cedula'] }}</td>
                        <td class="border">{{ $dataRegistro['factura'] }}</td>
                        <td class="border">{{ $dataRegistro['receta'] }} </td>
                        <td class="border">{{ $dataRegistro['cantidad_adquirida'] }} </td>
                        <td class="border">{{ $dataRegistro['cantidad_vendida'] }} </td>
                        <td class="border">{{ $dataRegistro['saldo'] }} </td>
                        <td class="border">{{ $dataRegistro['observaciones'] }}</td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</body>

</html>
